<?php
/**
 * config.php (PDO + MySQLi) - FINAL
 * - $conn  : PDO connection (للـ API)
 * - $pdo   : Alias لنفس اتصال PDO
 * - $mysqli: MySQLi connection (لأي سكربتات قديمة تعتمد mysqli)
 *
 * ✅ reCAPTCHA keys:
 * - RECAPTCHA_SITE_KEY  : للواجهة فقط (register.php)
 * - RECAPTCHA_SECRET    : للسيرفر فقط (get_register.php) — لا تضعه أبداً في الواجهة
 */

// ========================
// 1) إعدادات قاعدة البيانات
// ========================
$DB_HOST = "localhost";
$DB_NAME = "eazzqthc_eazzybit";
$DB_USER = "eazzqthc_eazzybit";
$DB_PASS = "@Eazzybit6200";

// (اختياري) إعدادات عامة
define("SITE_NAME", "YemenCash");
define("SITE_URL",  "https://yemencash.net");

// ========================
// 0) reCAPTCHA Settings (تم إدخال المفاتيح التي أرسلتها)
// ========================
// ملاحظة: الأفضل وضعها كـ Environment Variables على الاستضافة، لكن هذا يعمل مباشرة.
define("RECAPTCHA_SITE_KEY", getenv("RECAPTCHA_SITE_KEY") ?: "6Ld8XzEsAAAAAGyDCiy-W4hEv8wucuXCFNpQZ-Wm");
define("RECAPTCHA_SECRET",   getenv("RECAPTCHA_SECRET")   ?: "6Ld8XzEsAAAAAEulr9hgmL16ekjI2l_anENRNvUU");

// (اختياري) لو تستخدم reCAPTCHA v3 فقط (Score-based)
define("RECAPTCHA_MIN_SCORE", 0.5);

// ========================
// 2) PDO Connection  ($conn)
// ========================
$pdo  = null;
$conn = null;

if (extension_loaded("pdo_mysql")) {
  try {
    $dsn = "mysql:host={$DB_HOST};dbname={$DB_NAME};charset=utf8mb4";

    $pdo = new PDO($dsn, $DB_USER, $DB_PASS, [
      PDO::ATTR_ERRMODE            => PDO::ERRMODE_EXCEPTION,
      PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
      PDO::ATTR_EMULATE_PREPARES   => false,
    ]);

    // متغير API الأساسي
    $conn = $pdo;

  } catch (Throwable $e) {
    error_log("PDO_CONNECT_FAIL: " . $e->getMessage());
    $pdo  = null;
    $conn = null;
  }
} else {
  error_log("PDO driver pdo_mysql not loaded");
}

// ========================
// 3) MySQLi Connection ($mysqli)
// ========================
$mysqli = null;

if (extension_loaded("mysqli")) {
  $mysqli = @new mysqli($DB_HOST, $DB_USER, $DB_PASS, $DB_NAME);

  if ($mysqli->connect_errno) {
    error_log("MYSQLI_CONNECT_FAIL: " . $mysqli->connect_error);
    $mysqli = null;
  } else {
    if (!$mysqli->set_charset("utf8mb4")) {
      error_log("MYSQLI_SET_CHARSET_FAIL: " . $mysqli->error);
    }
  }
} else {
  error_log("MySQLi extension not loaded");
}
